##### Top threats
- **Sensitive data exposure**
  **Definition:** Sensitive data exposure includes data that identifies an individual which may allow for fraud, such as payment card or order information. Additionally, it may allow access to secure environments such as credentials or information that is confidential and proprietary to Dell or customers, such as code.
- **Broken access controls** - includes Improper Authentication and Improper Authorization
  Authorization is the process of verifying that a requested action or service is approved for a specific entity. Authorization is distinct from authentication, which is the process of verifying an entity's identity.
- **Command injection**
  **Definition:** It is a technique used via a web interface to execute commands on a web server. A bad actor supplies commands through a vulnerable web interface to execute OS commands. With the ability to execute OS commands, a bad actor can upload malicious programs, execute code, denial of service, sensitive information disclosure, privilege escalation or data loss. There are two types: **SQL injection and OS Command injections**.
  **Detection**: It can be detected by examining the source code and through some automated testing such as Static Application Security Testing and Dynamic Application Security Testing.
- **XSS - Cross site scripting** 
  **Definition:** Cross-Site Scripting (XSS) is an injection vulnerability that occurs when input is injected into a browser via HTML, JavaScript (JS), embedded extensions, or other client-side technology such as CSS, URL, and XML. Another source is unsafe links in social engineering attacks. XSS attacks often use the HTTP and HTTPs protocol (browser) indirectly for performing some attacks, particularly vulnerable websites, which allow malicious users to post HTML or JS in the application.
  **Detection:** XSS can be easily detected through automated tools such as static code analysis (e.g., Fortify) and web application scanning tools (e.g., IBM App Scan or BURP).

![[FY25Threats_Checklist.pdf]]